/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.crucible;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.SerializableRecipe;

public class CrucibleRecipe
extends SerializableRecipe {
    public static RecipeType<CrucibleRecipe> RECIPE_TYPE;
    @Nullable
    private static RegistryObject<ExNihiloRecipeSerializer<CrucibleRecipe>> serializer;
    private int amount;
    @Nullable
    private CrucibleTypeEnum crucibleType;
    @Nonnull
    private Ingredient input;
    @Nonnull
    private FluidStack resultFluid;

    public CrucibleRecipe(@Nonnull ResourceLocation id, @Nonnull Ingredient input, int amount, @Nonnull FluidStack fluid, @Nonnull CrucibleTypeEnum crucibleType) {
        super(null, RECIPE_TYPE, id);
        this.input = input;
        this.amount = amount;
        this.resultFluid = fluid;
        this.crucibleType = crucibleType;
    }

    @Nullable
    public static RegistryObject<ExNihiloRecipeSerializer<CrucibleRecipe>> getStaticSerializer() {
        return serializer;
    }

    public static void setSerializer(@Nonnull RegistryObject<ExNihiloRecipeSerializer<CrucibleRecipe>> serializer) {
        CrucibleRecipe.serializer = serializer;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Nullable
    public CrucibleTypeEnum getCrucibleType() {
        return this.crucibleType;
    }

    public void setCrucibleType(@Nonnull String crucibleType) {
        this.crucibleType = CrucibleTypeEnum.getTypeByName(crucibleType);
    }

    @Nonnull
    public Ingredient getInput() {
        return this.input;
    }

    public void setInput(@Nonnull Ingredient input) {
        this.input = input;
    }

    @Nonnull
    public List<ItemStack> getInputs() {
        return Arrays.asList(this.input.m_43908_());
    }

    @Nonnull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public FluidStack getResultFluid() {
        return this.resultFluid;
    }

    public void setResultFluid(@Nonnull FluidStack resultFluid) {
        this.resultFluid = resultFluid;
    }

    @Nullable
    protected ExNihiloRecipeSerializer<CrucibleRecipe> getENSerializer() {
        if (serializer == null) {
            return null;
        }
        return (ExNihiloRecipeSerializer)((Object)serializer.get());
    }
}

